<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

namespace StemBase\Modules\Shortcodes\Shortcode;

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

use StemBase\Modules\Shortcodes\Shortcode\ShortcodeBase;

class BlankBox extends ShortcodeBase {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $counter = 1;
	

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $name = "blankbox";
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $version = "1.0";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $help = "";
	
	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_usage = "[blankbox bg=\"bg-x\" padding=\"20\"]...content...[/blankbox]";

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $sample_attributes = array(
		array(
			"name"		=> "bg",
			"hint"		=> "#hexcode|bg-id|transparent, default: transparent"
		),

		array(
			"name"		=> "width",
			"hint"		=> "value in px or %, default: 100%"
		),

		array(
			"name"		=> "align",
			"hint"		=> "left|center|right, default: center. Position of the box among the rest of the content."
		),

		array(
			"name"		=> "border",
			"hint"		=> "#hexcode|transparent, default: transparent"
		),

		array(
			"name"		=> "border_size",
			"hint"		=> "value in px, default: skin default"
		),

		array(
			"name"		=> "radius",
			"hint"		=> "square|round|corners, default: square"
		),


		array(
			"name"		=> "padding",
			"hint"		=> "value in px or %, default: skin default."
		),

		array(
			"name"		=> "padding_left",
			"hint"		=> "value in px or %, default: skin default."
		),

		array(
			"name"		=> "padding_right",
			"hint"		=> "value in px or %, default: skin default."
		),

		array(
			"name"		=> "padding_top",
			"hint"		=> "value in px or %, default: skin default."
		),

		array(
			"name"		=> "padding_bottom",
			"hint"		=> "value in px or %, default: skin default."
		),

		array(
			"name"		=> "margin",
			"hint"		=> "value in px or %, default: skin default."
		),

		array(
			"name"		=> "margin_left",
			"hint"		=> "value in px or %, default: skin default."
		),

		array(
			"name"		=> "margin_right",
			"hint"		=> "value in px or %, default: skin default."
		),

		array(
			"name"		=> "margin_top",
			"hint"		=> "value in px or %, default: skin default."
		),

		array(
			"name"		=> "margin_bottom",
			"hint"		=> "value in px or %, default: skin default."
		),


		array(
			"name"		=> "class",
			"hint"		=> "custom css class to the wrapping element for future customization",			
		),
	
	);

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($data) {

		$this->loadTemplate();

		$vars	= $data["vars"];
		$css	= array();
		$style	= array();
		$style_inner	= array();
		$attr	= array();

		switch ($vars["align"]) {
			default: 
				$vars["align"] = "center";
				$css[] = "center"; 
			break;

			case "left": $css[] = "left"; break;
			case "right": $css[] = "right"; break;
		}

		if ($vars["width"]) {
			//debug($vars);
			if ($vars["align"] == "center") {
				$style_inner[] = "width: " . $this->getSize($vars["width"]); ;
			} else {			
				$style[] = "width: " . $this->getSize($vars["width"]); 
			}
		}

		if ($vars["padding"])		{ $style_inner[] = "padding: " . $this->getSize($vars["padding"]);}
		if ($vars["padding_left"])	{ $style_inner[] = "padding_left: " . $this->getSize($vars["padding_left"]); }
		if ($vars["padding_right"])	{ $style_inner[] = "padding_right: " . $this->getSize($vars["padding_right"]); }
		if ($vars["padding_top"])	{ $style_inner[] = "padding_top: " . $this->getSize($vars["padding_top"]); }
		if ($vars["padding_bottom"]){ $style_inner[] = "padding_bottom: " . $this->getSize($vars["padding_bottom"]); }

		if ($vars["margin"])		{ $style[] = "padding: " . $this->getSize($vars["margin"]);	}	
		if ($vars["margin_left"])	{ $style[] = "padding_left: " . $this->getSize($vars["margin_left"]); 	}
		if ($vars["margin_right"])	{ $style[] = "padding_right: " . $this->getSize($vars["margin_right"]); }
		if ($vars["margin_top"])	{ $style[] = "padding_top: " . $this->getSize($vars["margin_top"]); }
		if ($vars["margin_bottom"]) { $style[] = "padding_bottom: " . $this->getSize($vars["margin_bottom"]); }

		if ($vars["radius"]) {
			switch ($vars["radius"]) {
				case "round":	$css[] = "round";	break;
				case "corners": $css[] = "corners";	break;
				default:		$css[] = "corners";	break;
			}			
		}
		
		if ($vars["border"]) {
			$style_inner[] = $this->getBackground($vars["border"] , "border-color")["bg_style"];
			$css[] = "blankbox-border";
		}

		if ($vars["border_size"]) {
			$style_inner[] = "border-width:" .  $this->getSize($vars["border_size"]);
			$css[] = "blankbox-border";
		}
		

		$info = array(
			"content"		=> $vars["content"],
			"style"			=> implode(" " , $style),
			"style_inner"	=> implode(" " , $style_inner),
			"css"			=> implode(" " , $css),
//			"bg:scheme"	=> "nc",
		);

		return array(
			"content"	=> $this->tpl->blockReplace(
				"Main" , 
				$info,
				$this->getBackground($vars["bg"]),
				array(
				)
			),			
			"before"	=> "",
			"after"		=> "",
		);

	}
	
	
}